/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev;

import frc.emul.psg.dev.ISamplesProcessor;
import frc.emul.util.Utils;

public abstract class AbstractSamplesProcessor
implements ISamplesProcessor {
    protected int accuABC;
    protected int accuA;
    protected int accuB;
    protected int accuC;
    protected int maxABC;
    protected int maxA;
    protected int maxB;
    protected int maxC;
    private int threshold;
    private int count;

    protected abstract void processData();

    protected AbstractSamplesProcessor() {
        this.setThreshold(0);
    }

    protected AbstractSamplesProcessor(int n) {
        this.setThreshold(n);
    }

    public void setThreshold(int n) {
        this.count = 0;
        this.threshold = n;
        this.clear();
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void feedSample(int n, int n2, int n3, int n4) {
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("Invalid sample value $" + Utils.HEX(8, n) + " (A=" + Utils.HEX(8, n2) + ", B=" + Utils.HEX(8, n3) + ", C=" + Utils.HEX(8, n4) + ")");
        }
        if (n > this.maxABC) {
            this.maxABC = n;
        }
        if (n2 > this.maxA) {
            this.maxA = n2;
        }
        if (n3 > this.maxB) {
            this.maxB = n3;
        }
        if (n4 > this.maxC) {
            this.maxC = n4;
        }
        this.accuABC += n;
        this.accuA += n2;
        this.accuB += n3;
        this.accuC += n4;
        if (this.threshold > 0 && ++this.count >= this.threshold) {
            this.flush(this.count);
            this.clear();
        }
    }

    public void startFeeding(int n) {
        if (this.threshold == 0) {
            this.clear();
        }
    }

    public void endFeeding(int n) {
        if (this.threshold == 0) {
            this.flush(n);
        }
    }

    private void flush(int n) {
        if (n > 0) {
            this.accuABC /= n;
            this.accuA /= n;
            this.accuB /= n;
            this.accuC /= n;
        }
        this.processData();
    }

    private void clear() {
        this.accuABC = 0;
        this.accuA = 0;
        this.accuB = 0;
        this.accuC = 0;
        this.maxABC = 0;
        this.maxA = 0;
        this.maxB = 0;
        this.maxC = 0;
        this.count = 0;
    }
}

